<?php /*>*/ if (!defined('PmWiki')) exit();
#
# grease/grease.php v0.2
#
# PmWiki Grease skin code
# Copyright 2005 Dominique Faure (dfaure@cpan.org)
# This file is part of the PmWiki Monobook skin; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or (at your
# option) any later version.
#
# 05/08/23: Initial release.
# 05/08/24: Minor bug fix.
# 05/09/05: Fixed several visual bugs including latest SideBar styling.
# 05/09/07: Added handling of Site.PageActions (introduced with PmWiki v2.0
#           default skin).
# 05/10/06: Added header customization feature.
#

global $SkinPartFmt, $WikiTitle;
SDVA($SkinPartFmt, array(
'wikititle' => "$WikiTitle - {\$Titlespaced}",
'title' => '{$Titlespaced}',
'subtitle' => '[[{$Groupspaced}]]&nbsp;&#8594;&nbsp;[[{$Namespaced}]]',
'actions' => '
* %item rel=nofollow accesskey=$[ak_search]%[[$[Search] -> {$SiteGroup}.Search]]
* %item accesskey=$[ak_recentchanges]%[[$[Recent Changes]]]
',
'pageactions' => '
* %item rel=nofollow%[[$[Printable View] -> {$PageUrl}?action=print]]
* %item rel=nofollow%[[$[Page History] -> {$PageUrl}?action=diff]]
* %item rel=nofollow%[[$[Edit Page] -> {$PageUrl}?action=edit]]
* %item rel=nofollow%[[$[Upload] -> {$PageUrl}?action=upload]]',
'sep' => '&middot;',
'sidebardisabled' => false,
));

function RenderStyle($pagename, $params) {
  global $SkinPartFmt;
  preg_match('/^\s*(!?)\s*(\S+)\s*(.*)$/s', $params, $m);
  $bool = $SkinPartFmt[$m[2]];
  print ($m[1] ? ! $bool : $bool) ? "<style type='text/css'>$m[3]</style>" : '<!--$m[1]-->';
}

function RenderTitle($pagename) {
  global $SkinPartFmt, $PCache;
  if(!isset($PCache[$pagename]['skin_wikititle']))
    $PCache[$pagename]['skin_wikititle'] =
      preg_replace("/(<[^>]+>|\r\n?|\n\r?)/", '', MarkupToHTML($pagename, $SkinPartFmt['wikititle']));
  print $PCache[$pagename]['skin_wikititle'];
}

function RenderPart($pagename, $part) {
  global $SkinPartFmt, $PCache;
  $n = "skin_$part";
  if(!isset($PCache[$pagename][$n]))
    $PCache[$pagename][$n] =
      preg_replace("/<\/?p>/", '', MarkupToHTML($pagename, $SkinPartFmt[$part]));
  print $PCache[$pagename][$n];
}

function RenderActions($pagename, $actionslist) {
  global $SkinPartFmt, $PCache;
  if(!isset($PCache[$pagename]['skin_actions'])) {
    $pagelist = preg_split('/\s+/', $actionslist, -1, PREG_SPLIT_NO_EMPTY);
    foreach($pagelist as $p) {
      if (PageExists($p)) {
        $page = RetrieveAuthPage($p, 'read', false, READPAGE_CURRENT);
        $text = $page['text'];
        break;
      }
    }
    SDV($text, $SkinPartFmt['pageactions']);
    $text = preg_replace("/(\r\n|\n?\r)/", "\n", "$SkinPartFmt[actions]$text");
    $PCache[$pagename]['skin_actions'] = preg_replace('/(<\/li>)(?=\s*<li)/s', "$SkinPartFmt[sep] \\1", MarkupToHTML($pagename, $text));
  }
  print $PCache[$pagename]['skin_actions'];
}

# print handling
global $action;
if ($action == 'print') {
  global $LinkPageExistsFmt, $GroupPrintHeaderFmt, 
    $GroupPrintFooterFmt, $GroupHeaderFmt, $GroupFooterFmt;

  $LinkPageExistsFmt = "<a class='wikilink' href='{\$PageUrl}?action=print'>\$LinkText</a>";
  LoadPageTemplate($pagename, "$SkinDir/print.tmpl");
  return;
}

# sidebar markup
Markup('nosidebar', 'directives', '/\\(:nosidebar:\\)/ei', "SetTmplDisplay('PageRightFmt',0)");
Markup('noright',   'directives', '/\\(:noright:\\)/ei',   "NoSideBar()");

function NoSideBar() {
  global $SkinPartFmt;
  $SkinPartFmt['sidebardisabled'] = true;
  SetTmplDisplay('PageRightFmt', 0);
}


# links decoration
global $EnableSkinLinkDecoration, $IMapLinkFmt, $LinkPageCreateFmt, $LinkUploadCreateFmt, $UrlLinkFmt;
if(IsEnabled($EnableSkinLinkDecoration, 1)) {
  $IMapLinkFmt['Attach:'] = "<a class='attachlink' href='\$LinkUrl' rel='nofollow'>\$LinkText</a><a class='createlink' href='\$LinkUpload'><img src='$SkinDirUrl/attachment.png' /></a>";
  $LinkUploadCreateFmt = "<a class='createlinktext' href='\$LinkUpload'>\$LinkText</a><a class='createlink' href='\$LinkUpload'><img src='$SkinDirUrl/attachnew.png' /></a>";
  $LinkPageCreateFmt = "<a class='createlinktext' href='\$PageUrl?action=edit'>\$LinkText</a>";
#  $UrlLinkFmt =  "<span class='urllink'><a class='urllink' href='\$LinkUrl' rel='nofollow'>\$LinkText</a></span>";
}

# trails decoration
global $TrailFmt;
$TrailFmt = array(
  'head' => '&#8592; ',
  'tail' => ' &#8594;',
  'headB' => '&#8592; ',
  'tailB' => ' &#8594;',
  'sep' => ' &middot; ',
);
